package com.example.bytesbee.alphabets.activities;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.appcompat.widget.Toolbar;

import com.example.bytesbee.alphabets.activities.constants.Config;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.constants.IDialogListener;
import com.example.bytesbee.alphabets.activities.utils.Screens;
import com.example.bytesbee.alphabets.activities.utils.SessionManager;
import com.example.bytesbee.alphabets.activities.R;
import com.example.bytesbee.alphabets.activities.utils.Utils;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link http://bytesbee.com
 */
public class SettingsActivity extends AppCompatActivity implements OnClickListener {

    private SessionManager session;
    private SwitchCompat soundOnOff, vibrateOnOff, rtlOnOff;
    private Activity mActivity;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_settings);
        mActivity = this;
        session = new SessionManager(mActivity);

        try {
            final Toolbar mToolbar = findViewById(R.id.toolbar);
            setSupportActionBar(mToolbar);
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(R.string.lblSettings);
            mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
        } catch (Exception e) {
            Utils.getErrors(e);
        }

        final LinearLayout layoutSound = findViewById(R.id.layoutSound);
        final LinearLayout layoutVibrate = findViewById(R.id.layoutVibrate);
        final LinearLayout layoutRTL = findViewById(R.id.layoutRTL);
        final LinearLayout layoutRateApp = findViewById(R.id.layoutRateApp);
        final LinearLayout layoutShare = findViewById(R.id.layoutShare);
        final LinearLayout layoutAbout = findViewById(R.id.layoutAbout);
        final LinearLayout layoutPrivacyPolicy = findViewById(R.id.layoutPrivacyPolicy);

        final TextView txtSettingVersion = findViewById(R.id.txtSettingVersion);
        txtSettingVersion.setText(String.format(getString(R.string.settingVersion), Utils.getAppVersionName()));

        rtlOnOff = findViewById(R.id.rtlOnOff);
        rtlOnOff.setOnClickListener(v -> restartApp());

        rtlOnOff.setOnCheckedChangeListener((compoundButton, b) -> session.setOnOffRTL(b));

        soundOnOff = findViewById(R.id.soundOnOff);
        soundOnOff.setOnCheckedChangeListener((compoundButton, b) -> session.setOnOffSound(b));

        vibrateOnOff = findViewById(R.id.vibrateOnOff);
        vibrateOnOff.setOnCheckedChangeListener((compoundButton, b) -> session.setOnOffVibrate(b));

        if (session.isSoundOn()) {
            soundOnOff.setChecked(IConstants.TRUE);
        } else {
            soundOnOff.setChecked(IConstants.FALSE);
        }

        if (session.isVibrateOn()) {
            vibrateOnOff.setChecked(IConstants.TRUE);
        } else {
            vibrateOnOff.setChecked(IConstants.FALSE);
        }

        if (session.isRTLOn()) {
            rtlOnOff.setChecked(IConstants.TRUE);
        } else {
            rtlOnOff.setChecked(IConstants.FALSE);
        }

        layoutSound.setOnClickListener(this);
        layoutVibrate.setOnClickListener(this);
        layoutRTL.setOnClickListener(this);
        layoutRateApp.setOnClickListener(this);
        layoutShare.setOnClickListener(this);
        layoutAbout.setOnClickListener(this);
        layoutPrivacyPolicy.setOnClickListener(this);

        Utils.loadBannerAd(mActivity);
    }

    @Override
    public void onClick(final View view) {
        final int id = view.getId();
        if (id == R.id.layoutSound) {
            if (soundOnOff.isChecked()) {
                soundOnOff.setChecked(IConstants.FALSE);
            } else {
                soundOnOff.setChecked(IConstants.TRUE);
            }
        } else if (id == R.id.layoutVibrate) {
            if (vibrateOnOff.isChecked()) {
                vibrateOnOff.setChecked(IConstants.FALSE);
            } else {
                vibrateOnOff.setChecked(IConstants.TRUE);
            }
        } else if (id == R.id.layoutRTL) {
            if (rtlOnOff.isChecked()) {
                rtlOnOff.setChecked(IConstants.FALSE);
            } else {
                rtlOnOff.setChecked(IConstants.TRUE);
            }
            restartApp();
        } else if (id == R.id.layoutRateApp) {
            Utils.rateApp(mActivity);
        } else if (id == R.id.layoutShare) {
            Utils.shareApp(mActivity);
        } else if (id == R.id.layoutAbout) {
            Utils.showIntAds(mActivity, null, IConstants.COLORS, webViewHandler);
        } else if (id == R.id.layoutPrivacyPolicy) {
            Utils.showIntAds(mActivity, null, IConstants.SHAPES, webViewHandler);
        }
    }


    private final Handler webViewHandler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message message) {
            if (message.what == IConstants.COLORS) {
                Screens.openWebViewActivity(mActivity, getString(R.string.about), Config.PATH_ABOUT_US);
            } else if (message.what == IConstants.SHAPES) {
                Screens.openWebViewActivity(mActivity, getString(R.string.privacy_policy), Config.PATH_PRIVACY_POLICY);
            }
            return true;
        }
    });

    @Override
    public void onResume() {
        super.onResume();
    }

    private void restartApp() {
        Utils.showOKDialog(mActivity, R.string.ref_title, R.string.ref_message, new IDialogListener() {
            @Override
            public void yesButton() {
                Screens.showClearTopScreen(mActivity, MainActivity.class);
            }
        });
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
    }
}
